/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once
#include "stdafx.h"
#include "WorldObject.h"
#include "ArgVal.h"
#include "Brush.h"
#include "Frustum.h"
#include "TextureManager.h"

__gc class CEntity : public CWorldObject
{
private:
	Color3uc Color;
	bool bCulled;
	BoundingBox Box;
	ArrayList *ArgVals;
	ArrayList *Brushes;

public:
	CEntity(CConfig *Config) : CWorldObject(Config)
	{
		bCulled = false;

		Brushes = new ArrayList();
		ArgVals = new ArrayList();
	}

	void SetColor(unsigned char R, unsigned char G, unsigned char B)
	{
		Color.R = R;
		Color.G = G;
		Color.B = B;
	}

	void AddBrush(CBrush *Brush)
	{
		Brushes->Add(Brush);
	}

	void AddArgVal(CArgVal *ArgVal)
	{
		ArgVals->Add(ArgVal);
	}

	ArrayList *GetArgVals()
	{
		return ArgVals;
	}

	ArrayList *GetBrushes()
	{
		return Brushes;
	}

	String *GetName()
	{
		CArgVal* ArgVal;
		for(int i = 0; i < ArgVals->Count; i++)
		{
			ArgVal = static_cast<CArgVal*>(ArgVals->get_Item(0));
			if(ArgVal->GetArg()->ToLower()->Equals("classname"))
			{
				return ArgVal->GetVal();
			}
		}

		return S"unknowen";
	}

	int GetBrushCount()
	{
		return Brushes->Count;
	}

	void UpdateBoundingBoxes()
	{
		if(Brushes->Count == 0)
			return;

		CBrush *Brush;
		BoundingBox BrushBox;

		Brush = static_cast<CBrush*>(Brushes->get_Item(0));
		Brush->UpdateBoundingBoxes();
		BrushBox = Brush->GetBoundingBox();
		
		Box.vNegBound.X = BrushBox.vNegBound.X;
		Box.vNegBound.Y = BrushBox.vNegBound.Y;
		Box.vNegBound.Z = BrushBox.vNegBound.Z;
		Box.vPosBound.X = BrushBox.vPosBound.X;
		Box.vPosBound.Y = BrushBox.vPosBound.Y;
		Box.vPosBound.Z = BrushBox.vPosBound.Z;

		for(int i = 1; i < Brushes->Count; i++)
		{
			Brush = static_cast<CBrush*>(Brushes->get_Item(i));

			Brush->UpdateBoundingBoxes();
			BrushBox = Brush->GetBoundingBox();

			if(BrushBox.vNegBound.X < Box.vNegBound.X)
				Box.vNegBound.X = BrushBox.vNegBound.X;

			if(BrushBox.vNegBound.Y < Box.vNegBound.Y)
				Box.vNegBound.Y = BrushBox.vNegBound.Y;

			if(BrushBox.vNegBound.Z < Box.vNegBound.Z)
				Box.vNegBound.Z = BrushBox.vNegBound.Z;

			if(BrushBox.vPosBound.X > Box.vPosBound.X)
				Box.vPosBound.X = BrushBox.vPosBound.X;

			if(BrushBox.vPosBound.Y > Box.vPosBound.Y)
				Box.vPosBound.Y = BrushBox.vPosBound.Y;

			if(BrushBox.vPosBound.Z > Box.vPosBound.Z)
				Box.vPosBound.Z = BrushBox.vPosBound.Z;
		}
	}

	void CullEntity(CFrustum *Frustum)
	{
		bCulled = false;
		for(int i = 0; i < Brushes->Count; i++)
		{
			bCulled |= static_cast<CBrush*>(Brushes->get_Item(i))->CullBrush(Frustum);
		}
	}

	void UpdateTexCoords(CTextureManager *TextureManager)
	{
		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->UpdateTedCoords(TextureManager);
		}
	}

	void DrawEntityTextured()
	{
		if(false)//bCulled)
			return;

		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->DrawBrushTextured();
		}
	}

	void DrawEntitySolid()
	{
		if(false)//bCulled)
			return;

		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->DrawBrushSolid();
		}
	}

	void DrawEntityWireFrame()
	{
		if(false)//bCulled)
			return;

		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->DrawBrushWireFrame();
		}
	}

	void DrawEntityPoints()
	{
		if(false)//bCulled)
			return;

		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->DrawBrushPoints();
		}
	}

	void Highlight(bool bPrepared)
	{
		if(!bPrepared)
		{
			PrepareHighlight();
		}

		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->Highlight(true);
		}
	}

	void Outline()
	{
		for(int i = 0; i < Brushes->Count; i++)
		{
			static_cast<CBrush*>(Brushes->get_Item(i))->Outline();
		}
	}
};